#include "MTAGLContext.h"
#include "MTUtilities.h"
#include "MTExceptions.h"
#include "MTApplication.h"

#include <agl.h>

MTAGLContext	* gTheAGLContext;

MTAGLContext::MTAGLContext()
{
	offscreenWorld = nil;
	drawContext = nil;
	theWindow = nil;
	
	gTheAGLContext = this;
}

MTAGLContext::~MTAGLContext()
{
	Dispose();
	
	gTheAGLContext = nil;
}

void MTAGLContext::Create(UInt32 width, UInt32 height)
{
	if(!gTheApp->hasAGL)
		return;
	
	if(!offscreenWorld)
	{
		OSErr	theErr;
		Rect	where;
		
		SET_RECT(where, 0, 0, width, height);
		
		theErr = NewGWorld(&offscreenWorld, 32, &where, nil, 0, 0);
		if(theErr)
			throw MTOSException(theErr, "Error creating buffer GWorld");
	}
	
	#if 1	/* 0 = debugging extra window, 1 = release double buffering */
	
	if(!drawContext)
	{
		PixMapHandle	pixMap;
		AGLPixelFormat	pixelFormat;
		GLboolean		isOK;
		GLint			attributes[] = { AGL_RGBA, AGL_PIXEL_SIZE, 0, AGL_OFFSCREEN, AGL_NONE };
		
		pixMap = GetGWorldPixMap(offscreenWorld);
		LockPixels(pixMap);
		
		attributes[2] = 32;
		
		pixelFormat = aglChoosePixelFormat(nil, 0, attributes);
		if(!pixelFormat)
			throw MTException("MTPNTA3DViewer::CreateAGLContext: couldn't create pixel format");
		
		drawContext = aglCreateContext(pixelFormat, nil);
		if(!drawContext)
			throw MTException("MTPNTA3DViewer::CreateAGLContext: couldn't create context");
		
		isOK = aglSetOffScreen(drawContext, width, height, GetPixRowBytes(pixMap) & 0x3FFF, GetPixBaseAddr(pixMap));
		if(!isOK)
			throw MTException("MTPNTA3DViewer::CreateAGLContext: couldn't set up offscreen drawing");
		
		isOK = aglSetCurrentContext(drawContext);
		if(!isOK)
			throw MTException("MTPNTA3DViewer::CreateAGLContext: couldn't make context current context");
		
		aglDestroyPixelFormat(pixelFormat);
	}
	
	#else
	
	if(!drawContext)
	{
		Rect	where;
		
		SET_RECT(where, 100, 100, 100 + width, 100 + height);
		
		theWindow = NewCWindow(nil, &where, "\pStuff w/ Things", false, documentProc, (WindowPtr)-1, true, 0);
		ShowWindow(theWindow);
		
		GLint          attrib[] = { AGL_RGBA, AGL_ACCELERATED, AGL_NONE };
		AGLPixelFormat fmt;
		GLboolean      ok;
		
		/* Choose an rgb pixel format */
		fmt = aglChoosePixelFormat(NULL, 0, attrib);
		
		/* Create an AGL context */
		drawContext = aglCreateContext(fmt, NULL);
		
		/* Attach the window to the context */
		ok = aglSetDrawable(drawContext, (CGrafPort *)theWindow);
		
		/* Make the context the current context */
		ok = aglSetCurrentContext(drawContext);
		
		/* Pixel format is no longer needed */
		aglDestroyPixelFormat(fmt);
	}
	
	#endif
}

void MTAGLContext::Dispose(void)
{
	if(drawContext)
	{
		aglSetCurrentContext(nil);
		aglSetDrawable(drawContext, nil);
		aglDestroyContext(drawContext);
		
		drawContext = nil;
	}
	
	if(offscreenWorld)
	{
		UnlockPixels(GetGWorldPixMap(offscreenWorld));
		DisposeGWorld(offscreenWorld);
		
		offscreenWorld = nil;
	}
	
	if(theWindow)
	{
		DisposeWindow(theWindow);
		
		theWindow = nil;
	}
}